
-- Data was inadvertently entered for wkf_case_id 98237. This script will undo 
-- that data entry.

-- Atlee Whiteleather
-- 11/25/2013  

declare @wkfId int
declare @test bit
declare @wkf_case_activity_id int
declare @questionnaire_id int
declare @laborder_id int
declare @labkit_id int
declare @referral_id int
declare @patient_id int 

set @patient_id = 5836679  -- Patient ID 
set @test = 0       -- 1 means to TEST, not to actually DELETE. 0 is DELETE

select @wkfId = WKF_CASE_ID
from WKF_CASE
where PATIENT_ID = @patient_id

print 'Reset patient information for wkf_case_id: ' + Convert(varchar(10), @wkfId) + 
      ' Mode: ' + Convert(varchar(1), @test) + ' PatientID: ' + Convert(varchar(10), @patient_id)

--
-- Delete the questionnaire  and associated workflow
--

select @wkf_case_activity_id = bmk.WKF_CASE_ACTIVITY_ID, 
       @questionnaire_id =  bmk.ID
from EFR.Ques_biological_monitoring_specimen_collection_kit bmk
join WKF_CASE_ACTIVITY wca on wca.WKF_CASE_ACTIVITY_ID = bmk.WKF_CASE_ACTIVITY_ID
where wca.WKF_CASE_ID = @wkfId
	
if @wkf_case_activity_id is not null
begin
	if @test = 0
	begin 	
		print 'Deleting Questionnaire: ' + Convert(varchar(10), @questionnaire_id)
		Delete from EFR.Ques_biological_monitoring_specimen_collection_kit 
		where ID = @questionnaire_id

		print 'Deleting Workflow Case Activity: ' + Convert(varchar(10), @wkf_case_activity_id)	
		Delete from WKF_CASE_ACTIVITY
		where WKF_CASE_ACTIVITY_ID = @wkf_case_activity_id
	end
	else -- just print out what's going to happen
	begin
		print 'Test: Deleting questionnaire_id: ' + Convert(varchar(10), @questionnaire_id)
		print 'Test: Deleting wkf_case_activity_id: ' + Convert(varchar(10), @wkf_case_activity_id)
	end
end
else
begin
	print 'No Questionnaire to Delete'
end

--
-- Delete Lab Order Detail and Lab Order
--

select @laborder_id = lo.lab_order_id,  
       @wkf_case_activity_id = lo.WKF_CASE_ACTIVITY_ID
from efr.LAB_ORDER lo
join WKF_CASE_ACTIVITY wca on wca.WKF_CASE_ACTIVITY_ID = lo.WKF_CASE_ACTIVITY_ID
where wca.WKF_CASE_ID = @wkfId 

if @laborder_id is not null
begin
	if (@test = 0)
	begin		
		print 'Delete Lab Order Detail: ' + Convert(varchar(10), @laborder_id)
		delete from efr.LAB_ORDER_DETAIL 
		where Lab_order_id = @laborder_id
		
		print 'Delete Lab Order: ' + Convert(varchar(10), @laborder_id)
		delete from efr.LAB_ORDER 
		where Lab_order_id = @laborder_id		
		
		print 'Delete associated workflow activity: ' + Convert(varchar(10), @wkf_case_activity_id)
		Delete from WKF_CASE_ACTIVITY
		where WKF_CASE_ACTIVITY_ID = @wkf_case_activity_id
		
		-- delete the lab kit placeholder	
		
		print 'Delete shipping detail and associated workflow activity' 
		
		delete from EFR.SHIPPING_DETAIL 
		where wkf_case_activity_id in
		( select WKF_CASE_ACTIVITY_ID 
		  from WKF_CASE_ACTIVITY
		  where WKF_CASE_ID = @wkfId AND STD_WKFACTIVITYTYPE_ID = 1)

		Delete from WKF_CASE_ACTIVITY
		where WKF_CASE_ID = @wkfId AND STD_WKFACTIVITYTYPE_ID in (1, 4)
	end
	else
	begin
		print 'Test: Deleting Lab Order and Lab Order Detail: ' + Convert(varchar(10), @laborder_id)
		print 'Test: Deleting Workflow Case Activity: ' + Convert(varchar(10), @wkf_case_activity_id)
		print 'Test: Deleting Workflow: ' + Convert(varchar(10), @wkfId)	
	end
end
else
begin
	print 'No Lab Order to Delete'
end

-- 
-- Delete the workflow case itself, if it exists
--

if @wkfId is not null
begin
	if @test = 0
	begin
		print 'Deleting any additional workflows'
		Delete from WKF_CASE_ACTIVITY
		where WKF_CASE_ID = @wkfId
		
		print 'Delete associated workflow' 
		Delete from WKF_CASE
		where WKF_CASE_ID = @wkfId
	end
	else
	begin
		print 'Test: Delete associated workflow'
	end
end
else
begin
	print 'No associated workflow to delete'
end 
	
--
-- reset the referral status
--

select @referral_id = REFERRAL_ID
from REFERRAL
where PATIENT_ID = @patient_id
	and STD_REFERRALSTS_ID in (5, 6, 7, 8, 9, 10)
	
if @referral_id is not null
begin	
	if @test = 0
	begin
		print 'Resetting Referral Status: ' + Convert(varchar(10), @referral_id)
		update REFERRAL 
		set STD_REFERRALSTS_ID = 4
		where REFERRAL_ID = @referral_id
	end
	else
	begin
		print 'Test: Resetting Referral Status: ' + Convert(varchar(10), @referral_id)
	end
end
else
begin
	print 'No Referral found to reset'
end

print 'Completed updates' 


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R6'
           ,'00'
           ,'001'
           ,0
           ,'30480 - remove data for patient 5836679'
		   ,'Script will remove inadvertently entered data for 5836679'
           ,'EFR'
           ,GETDATE())

GO